#include "DataCylinder.h"

namespace DataTypes
{

DataCylinder::DataCylinder()
{
}

DataCylinder::DataCylinder(int bodyid, float radius, float length, Vector3f position,Vector3f rotation,int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity): DataBody(bodyid, materialid, mass,linearvelocity, angularvelocity)
{
	this->radius = radius;
	this->length = length;
	this->position = position;
	this->rotation = rotation;
}

DataCylinder::~DataCylinder()
{
}

float DataCylinder::GetRadius()
{
	return radius;
}

float DataCylinder::GetLength()
{
	return length;
}

Vector3f DataCylinder::GetPosition()
{
	return position;
}

Vector3f DataCylinder::GetRotation()
{
	return rotation;
}

void DataCylinder::SetRadius(float value)
{
	this->radius = value;
}

void DataCylinder::SetLength(float value)
{
	this->length = value;
}

void DataCylinder::SetPosition(Vector3f value)
{
	this->position = value;
}

void DataCylinder::SetRotation(Vector3f value)
{
	this->rotation = value;
}

string DataCylinder::ToString()
{
	stringstream id,material, mass;
	id<< this->GetBodyId();
	material<< this->GetMaterialId();
	mass<<this->GetMass();
	stringstream leng;
	leng<< this->length;
	stringstream rad;
	rad<< this->radius;
	return "<Body Type=\"Cylinder\"><Body_id>"+id.str()+"</Body_id><Material>"+ material.str()+"</Material><Mass>"+mass.str()+"</Mass><Length>"+leng.str()+"</Length>"+
				"<Radius>"+rad.str()+"</Radius>"
				+ position.ToString("Position_X","Position_Y","Position_Z")+
				rotation.ToString("Rotation_X","Rotation_Y","Rotation_Z")+this->GetLinearVelocity().ToString("Linear_Velocity_X","Linear_Velocity_Y","Linear_Velocity_Z")+this->GetAngularVelocity().ToString("Angular_Velocity_X","Angular_Velocity_Y","Angular_Velocity_Z")+"</Body>";
}

}
